/*
 * Decompiled with CFR 0.152.
 */
package com.ardublock.translator.block;

import com.ardublock.translator.Translator;
import com.ardublock.translator.block.TranslatorBlock;
import com.ardublock.util.PropertiesReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;

public class TranslatorBlockFactory {
    private static final String BLOCK_MAPPING = "com/ardublock/block/block-mapping.properties";
    private Map<String, String> shortClassName = new HashMap<String, String>();

    public TranslatorBlockFactory() {
        this.shortClassName.put("analogInput", "com.ardublock.translator.block.AnalogInputBlock");
        this.shortClassName.put("digitalInput", "com.ardublock.translator.block.DigitalInputBlock");
        this.shortClassName.put("analogOutput", "com.ardublock.translator.block.AnalogOutputBlock");
        this.shortClassName.put("digitalOutput", "com.ardublock.translator.block.DigitalOutputBlock");
        this.shortClassName.put("inversedDigitalInput", "com.ardublock.translator.block.InversedDigitalInputBlock");
        this.shortClassName.put("inversedDigitalOutput", "com.ardublock.translator.block.InversedDigitalOutputBlock");
        this.shortClassName.put("inversedAnalogOutput", "com.ardublock.translator.block.InversedAnalogOutputBlock");
        this.shortClassName.put("servo", "com.ardublock.translator.block.ServoBlock");
    }

    public TranslatorBlock buildTranslatorBlock(Translator translator, Long blockId, String blockName, String codePrefix, String codeSuffix, String label) {
        String className = PropertiesReader.getValue(blockName, BLOCK_MAPPING);
        String longName = this.shortClassName.get(className);
        if (longName != null) {
            className = longName;
        }
        try {
            Class<?> blockClass = Class.forName(className);
            Constructor<?> constructor = blockClass.getConstructor(Long.class, Translator.class, String.class, String.class, String.class);
            TranslatorBlock ret = (TranslatorBlock)constructor.newInstance(blockId, translator, codePrefix, codeSuffix, label);
            return ret;
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            System.err.println(blockName + " not suitable class!");
        }
        System.err.println(blockName + " not found!");
        return null;
    }
}

