/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.blocks.codeblockutil;

import edu.mit.blocks.codeblockutil.CButton;
import edu.mit.blocks.codeblockutil.CGlassScrollPane;
import edu.mit.blocks.codeblockutil.CScrollPane;
import edu.mit.blocks.codeblockutil.Canvas;
import edu.mit.blocks.codeblockutil.Explorer;
import edu.mit.blocks.codeblockutil.GlassExplorer;
import edu.mit.blocks.codeblockutil.GraphicsManager;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;

public class GlassCard
implements ActionListener,
PropertyChangeListener {
    private int index;
    private Explorer explorer;
    private Canvas canvas;
    private CButton button;
    private CScrollPane scroll;
    private static final int SCROLLBAR_WIDTH = 18;

    GlassCard(int i, Canvas canvas, GlassExplorer ex) {
        this.index = i;
        this.explorer = ex;
        this.canvas = canvas;
        this.button = new GlassButton(canvas.getColor(), canvas.getColor().brighter().brighter().brighter(), canvas.getName());
        this.scroll = new CGlassScrollPane(canvas.getJComponent(), CScrollPane.ScrollPolicy.VERTICAL_BAR_AS_NEEDED, CScrollPane.ScrollPolicy.HORIZONTAL_BAR_NEVER, 18, canvas.getColor(), new Color(100, 100, 100, 100));
        canvas.getJComponent().setOpaque(false);
        this.button.addActionListener(this);
        canvas.getJComponent().addPropertyChangeListener(this);
        this.scroll.setPreferredSize(new Dimension(canvas.getJComponent().getPreferredSize().width + 18, canvas.getJComponent().getPreferredSize().height));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.explorer.selectCanvas(this.index);
    }

    JComponent getButton() {
        return this.button;
    }

    JComponent getScroll() {
        return this.scroll;
    }

    Color getBackgorundColor() {
        return new Color(this.canvas.getColor().getRed(), this.canvas.getColor().getGreen(), this.canvas.getColor().getBlue(), 150);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("label_change_property")) {
            this.button.repaint();
        }
        if (e.getSource().equals(this.canvas) && e.getPropertyName().equals("preferredSize")) {
            this.scroll.setPreferredSize(new Dimension(this.canvas.getJComponent().getPreferredSize().width + 18, this.canvas.getJComponent().getPreferredSize().height));
        }
    }

    private class GlassButton
    extends CButton {
        private static final long serialVersionUID = 328149080429L;
        private final int[][] shadowPositionArray;
        private final float[] shadowColorArray;
        private double offsetSize;

        public GlassButton(Color buttonColor, Color selectedColor, String text) {
            super(buttonColor, selectedColor, text);
            this.shadowPositionArray = new int[][]{{0, -1}, {1, -1}, {-1, 0}, {2, 0}, {-1, 1}, {1, 1}, {0, 2}, {1, 0}, {0, 1}};
            this.shadowColorArray = new float[]{0.5f, 0.5f, 0.5f, 0.5f, 0.5f, 0.5f, 0.5f, 0.0f, 0.0f};
            this.offsetSize = 1.0;
        }

        @Override
        public void paint(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            BufferedImage buffer = GraphicsManager.gc.createCompatibleImage(this.getWidth(), this.getHeight(), 3);
            Graphics2D gb = buffer.createGraphics();
            gb.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int buttonHeight = this.getHeight() - 6;
            int buttonWidth = this.getWidth() - 6;
            int arc = buttonHeight;
            if (this.pressed || this.selected) {
                g2.setPaint(new GradientPaint(0.0f, -buttonHeight, Color.darkGray, 0.0f, buttonHeight, GlassCard.this.canvas.getColor(), false));
                g2.fillRoundRect(3, 3, buttonWidth, buttonHeight, arc, arc);
                g2.setColor(Color.darkGray);
                g2.drawRoundRect(3, 3, buttonWidth, buttonHeight, arc, arc);
            } else {
                if (this.focus) {
                    gb.setColor(Color.yellow);
                    gb.setStroke(new BasicStroke(3.0f));
                    gb.drawRoundRect(3, 3, buttonWidth, buttonHeight, arc, arc);
                    gb.setStroke(new BasicStroke(1.0f));
                }
                gb.setColor(GlassCard.this.canvas.getColor().darker());
                gb.fillRoundRect(3, 3, buttonWidth, buttonHeight, arc, arc);
                gb.setColor(Color.darkGray);
                gb.drawRoundRect(3, 3, buttonWidth, buttonHeight, arc, arc);
                int highlightHeight = buttonHeight * 2 / 3;
                int highlightWidth = buttonWidth;
                int highlightArc = highlightHeight;
                gb.setComposite(AlphaComposite.getInstance(3, 0.8f));
                gb.setColor(GlassCard.this.canvas.getColor());
                gb.setClip(new RoundRectangle2D.Float(3.0f, 3.0f, highlightWidth, highlightHeight, highlightArc, highlightArc));
                gb.fillRoundRect(3, 3, buttonWidth, buttonHeight, arc, arc);
                ConvolveOp blurOp = new ConvolveOp(new Kernel(3, 3, BLUR));
                BufferedImage blurredImage = blurOp.filter(buffer, null);
                g2.drawImage((Image)blurredImage, 1, 1, null);
            }
            String text = GlassCard.this.canvas.getName();
            if (text != null && buttonHeight > 4) {
                Font font = g2.getFont().deriveFont((float)(this.getHeight() - 6 - 2) * 0.7f);
                g2.setFont(font);
                FontMetrics metrics = g2.getFontMetrics();
                Rectangle2D textBounds = metrics.getStringBounds(text, g2);
                float x = (float)((double)(this.getWidth() / 2) - textBounds.getWidth() / 2.0);
                float y = (float)((double)(this.getHeight() / 2) + textBounds.getHeight() / 2.0) - (float)metrics.getDescent();
                g.setColor(Color.black);
                for (int i = 0; i < this.shadowPositionArray.length; ++i) {
                    int dx = this.shadowPositionArray[i][0];
                    int dy = this.shadowPositionArray[i][1];
                    g2.setColor(new Color(0.0f, 0.0f, 0.0f, this.shadowColorArray[i]));
                    g2.drawString(text, x + (float)((int)((double)dx * this.offsetSize)), y + (float)((int)((double)dy * this.offsetSize)));
                }
                if (GlassCard.this.canvas.getHighlight() != null) {
                    g.setColor(GlassCard.this.canvas.getHighlight());
                } else {
                    g.setColor(Color.white);
                }
                g2.drawString(text, x, y);
            }
            if (GlassCard.this.canvas.getHighlight() != null) {
                g2.setStroke(new BasicStroke(3.0f));
                g2.setColor(GlassCard.this.canvas.getHighlight());
                g2.drawRoundRect(4, 4, buttonWidth - 2, buttonHeight - 2, arc, arc);
                g2.setStroke(new BasicStroke(1.0f));
            }
        }
    }
}

