/*
 * Decompiled with CFR 0.152.
 */
package com.ardublock.translator.block.teach;

import com.ardublock.translator.Translator;
import com.ardublock.translator.block.TranslatorBlock;
import com.ardublock.translator.block.exception.SocketNullException;
import com.ardublock.translator.block.exception.SubroutineNotDeclaredException;

public class PulseBlock
extends TranslatorBlock {
    public PulseBlock(Long blockId, Translator translator, String codePrefix, String codeSuffix, String label) {
        super(blockId, translator, codePrefix, codeSuffix, label);
    }

    public String toCode() throws SocketNullException, SubroutineNotDeclaredException {
        this.translator.addDefinitionCommand(" long pulse (int port, boolean stat, int timeout=120000){\n  unsigned long t=millis();\n  while(digitalRead(port)!=stat){\n    if(millis()-t>= timeout){\n      return 0;\n    }\n  }\n  t=millis();\n  while(digitalRead(port)==stat){}\n  return millis()-t;\n}\n      ");
        String ret = "pulse( ";
        TranslatorBlock tb = this.getRequiredTranslatorBlockAtSocket(0);
        this.translator.addSetupCommand("pinMode(" + tb.toCode() + ",INPUT);");
        ret = ret + tb.toCode() + " , ";
        tb = this.getRequiredTranslatorBlockAtSocket(1);
        ret = ret + tb.toCode() + " , ";
        tb = this.getRequiredTranslatorBlockAtSocket(2);
        ret = ret + tb.toCode() + " ) ";
        return this.codePrefix + ret + this.codeSuffix;
    }
}

