/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.blocks.codeblockutil;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.JToolTip;
import javax.swing.plaf.basic.BasicToolTipUI;

class CToolTipUI
extends BasicToolTipUI {
    private static final int WIDTH = 150;
    private CellRendererPane renderer;
    private JTextArea textArea;
    private Color background;

    public CToolTipUI(Color background) {
        this.background = background;
        this.renderer = new CellRendererPane();
        this.textArea = new JTextArea();
        this.textArea.setMargin(new Insets(0, 3, 0, 0));
        this.renderer.removeAll();
        this.renderer.add(this.textArea);
        this.textArea.setFont(new Font("Ariel", 0, 11));
        this.textArea.setWrapStyleWord(true);
        this.textArea.setLineWrap(true);
        this.textArea.setWrapStyleWord(true);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Dimension size = c.getSize();
        this.textArea.setBackground(this.background);
        this.renderer.paintComponent(g, this.textArea, c, 1, 1, size.width - 1, size.height - 1, true);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        String tipText = ((JToolTip)c).getTipText();
        if (tipText == null) {
            return new Dimension(0, 0);
        }
        this.textArea.setText(tipText);
        Dimension d = this.textArea.getPreferredSize();
        d.width = Math.min(d.width, 150);
        ++d.height;
        this.textArea.setSize(d);
        return d;
    }
}

