/*
 * Decompiled with CFR 0.152.
 */
package com.ardublock.ui.listener;

import com.ardublock.core.Context;
import com.ardublock.translator.Translator;
import com.ardublock.translator.block.exception.BlockException;
import com.ardublock.translator.block.exception.SocketNullException;
import com.ardublock.translator.block.exception.SubroutineNameDuplicatedException;
import com.ardublock.translator.block.exception.SubroutineNotDeclaredException;
import edu.mit.blocks.codeblocks.Block;
import edu.mit.blocks.renderable.RenderableBlock;
import edu.mit.blocks.workspace.Workspace;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.ResourceBundle;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class GenerateCodeButtonListener
implements ActionListener {
    private JFrame parentFrame;
    private Context context;
    private Workspace workspace;
    private ResourceBundle uiMessageBundle;

    public GenerateCodeButtonListener(JFrame frame, Context context) {
        this.parentFrame = frame;
        this.context = context;
        this.workspace = context.getWorkspaceController().getWorkspace();
        this.uiMessageBundle = ResourceBundle.getBundle("com/ardublock/block/ardublock");
    }

    public void actionPerformed(ActionEvent e) {
        Iterable<RenderableBlock> blocks;
        Long blockId;
        boolean success = true;
        Translator translator = new Translator(this.workspace);
        translator.reset();
        Iterable<RenderableBlock> renderableBlocks = this.workspace.getRenderableBlocks();
        HashSet<RenderableBlock> loopBlockSet = new HashSet<RenderableBlock>();
        HashSet<RenderableBlock> subroutineBlockSet = new HashSet<RenderableBlock>();
        StringBuilder code = new StringBuilder();
        for (RenderableBlock renderableBlock : renderableBlocks) {
            Block block = renderableBlock.getBlock();
            if (block.hasPlug() || !Block.NULL.equals(block.getBeforeBlockID())) continue;
            if (block.getGenusName().equals("loop")) {
                loopBlockSet.add(renderableBlock);
            }
            if (block.getGenusName().equals("program")) {
                loopBlockSet.add(renderableBlock);
            }
            if (block.getGenusName().equals("setup")) {
                loopBlockSet.add(renderableBlock);
            }
            if (!block.getGenusName().equals("subroutine")) continue;
            String functionName = block.getBlockLabel().trim();
            try {
                translator.addFunctionName(block.getBlockID(), functionName);
            }
            catch (SubroutineNameDuplicatedException e1) {
                this.context.highlightBlock(renderableBlock);
                JOptionPane.showMessageDialog(this.parentFrame, this.uiMessageBundle.getString("ardublock.translator.exception.subroutineNameDuplicated"), "Error", 0);
                return;
            }
            subroutineBlockSet.add(renderableBlock);
        }
        if (loopBlockSet.size() == 0) {
            JOptionPane.showMessageDialog(this.parentFrame, this.uiMessageBundle.getString("ardublock.translator.exception.noLoopFound"), "Error", 0);
            return;
        }
        if (loopBlockSet.size() > 1) {
            for (RenderableBlock rb : loopBlockSet) {
                this.context.highlightBlock(rb);
            }
            JOptionPane.showMessageDialog(this.parentFrame, this.uiMessageBundle.getString("ardublock.translator.exception.multipleLoopFound"), "Error", 0);
            return;
        }
        try {
            for (RenderableBlock renderableBlock : loopBlockSet) {
                Block loopBlock = renderableBlock.getBlock();
                code.append(translator.translate(loopBlock.getBlockID()));
            }
            for (RenderableBlock renderableBlock : subroutineBlockSet) {
                Block subroutineBlock = renderableBlock.getBlock();
                code.append(translator.translate(subroutineBlock.getBlockID()));
            }
            translator.beforeGenerateHeader();
            code.insert(0, translator.genreateHeaderCommand());
        }
        catch (SocketNullException e1) {
            e1.printStackTrace();
            success = false;
            blockId = e1.getBlockId();
            blocks = this.workspace.getRenderableBlocks();
            for (RenderableBlock renderableBlock2 : blocks) {
                Block block2 = renderableBlock2.getBlock();
                if (!block2.getBlockID().equals(blockId)) continue;
                this.context.highlightBlock(renderableBlock2);
                break;
            }
            JOptionPane.showMessageDialog(this.parentFrame, this.uiMessageBundle.getString("ardublock.translator.exception.socketNull"), "Error", 0);
        }
        catch (BlockException e2) {
            e2.printStackTrace();
            success = false;
            blockId = e2.getBlockId();
            blocks = this.workspace.getRenderableBlocks();
            for (RenderableBlock renderableBlock2 : blocks) {
                Block block2 = renderableBlock2.getBlock();
                if (!block2.getBlockID().equals(blockId)) continue;
                this.context.highlightBlock(renderableBlock2);
                break;
            }
            JOptionPane.showMessageDialog(this.parentFrame, e2.getMessage(), "Error", 0);
        }
        catch (SubroutineNotDeclaredException e3) {
            e3.printStackTrace();
            success = false;
            blockId = e3.getBlockId();
            blocks = this.workspace.getRenderableBlocks();
            for (RenderableBlock renderableBlock3 : blocks) {
                Block block2 = renderableBlock3.getBlock();
                if (!block2.getBlockID().equals(blockId)) continue;
                this.context.highlightBlock(renderableBlock3);
                break;
            }
            JOptionPane.showMessageDialog(this.parentFrame, this.uiMessageBundle.getString("ardublock.translator.exception.subroutineNotDeclared"), "Error", 0);
        }
        if (success) {
            if (!this.context.isInArduino()) {
                System.out.println(code.toString());
            }
            this.context.didGenerate(code.toString());
        }
    }
}

