/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.blocks.codeblockutil;

import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.net.URL;

public class ImageManager {
    private Component comp;

    public ImageManager(Component comp) {
        assert (comp != null);
        this.comp = comp;
    }

    public BufferedImage createImage(String file) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        URL u = ImageManager.class.getResource(file);
        if (u == null) {
            System.out.println("Could not find resource " + file);
            return null;
        }
        Image img = toolkit.createImage(u);
        if (img == null) {
            System.out.println("Couldn't load image " + file);
            return null;
        }
        MediaTracker mt = new MediaTracker(this.comp);
        try {
            mt.addImage(img, 0);
            mt.waitForAll();
        }
        catch (Exception e) {
            System.out.println("Couldn't load image " + file);
            System.out.println(e);
            return null;
        }
        if (mt.isErrorAny()) {
            System.out.println("Couldn't load image " + file);
            return null;
        }
        BufferedImage bimg = this.comp.getGraphicsConfiguration().createCompatibleImage(img.getWidth(this.comp), img.getHeight(this.comp), 3);
        bimg.getGraphics().drawImage(img, 0, 0, this.comp);
        return bimg;
    }

    public static boolean hitTest(BufferedImage img, int x, int y) {
        return (img.getRGB(x, y) >> 24 & 0xFF) >= 127;
    }
}

