// Numero de pin
const int trigPin = 3;
const int echoPin = 2;
const int buzzer = 6;
const int ledPin = 13;

// Variables 
long duration;
int distance;
int safetyDistance;


void setup() {
pinMode(trigPin, OUTPUT); 
pinMode(echoPin, INPUT); 
pinMode(buzzer, OUTPUT);
pinMode(ledPin, OUTPUT);
Serial.begin(9600); //inicia la comunicacion serial 
}


void loop() {
// Limpia trigPin
digitalWrite(trigPin, LOW);
delayMicroseconds(2);

// trigPin en HIGH 
digitalWrite(trigPin, HIGH);
delayMicroseconds(10);
digitalWrite(trigPin, LOW);

// lee echoPin, regresa en sonido 
duration = pulseIn(echoPin, HIGH);

// Calcula la distancia 
distance= duration*0.034/2;

safetyDistance = distance;
if (safetyDistance <= 15)
{
  digitalWrite(buzzer, HIGH);
  digitalWrite(ledPin, HIGH);
}
else
{
  digitalWrite(buzzer, LOW);
  digitalWrite(ledPin, LOW);
}
//muestra la distancia en el monito serial 
Serial.print("Distance: ");
Serial.println(distance);
delay (300);
}



